import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';

class CommentPage extends StatefulWidget {
  const CommentPage({Key? key}) : super(key: key);

  @override
  State<CommentPage> createState() => _CommentPageState();
}

class _CommentPageState extends State<CommentPage> {
  int? _select;
  @override
  Widget build(BuildContext context) {
    ScreenUtil.init(
        BoxConstraints(
            maxWidth: MediaQuery.of(context).size.width,
            maxHeight: MediaQuery.of(context).size.height),
        designSize: Size(360, 690),
        context: context,
        minTextAdapt: true,
        orientation: Orientation.portrait);
    return MaterialApp(
      debugShowCheckedModeBanner: false,
      home: Scaffold(
        resizeToAvoidBottomInset: true,
        appBar: AppBar(
          elevation: 0.55,
          shadowColor: Color.fromRGBO(77, 32, 126, 1),
          bottomOpacity: 0,
          backgroundColor: Color.fromRGBO(77, 32, 126, 1),
          toolbarHeight: 80.h,
          title: Row(mainAxisAlignment: MainAxisAlignment.start, children: [
            Container(
                margin: EdgeInsets.only(top: 10),
                child: GestureDetector(
                    onTap: () {
                      Navigator.pop(context);
                    },
                    child: Icon(Icons.arrow_back_ios))),
            SizedBox(
              width: 58,
            ),
            Text('แสดงความคิดเห็น/แจ้งปัญหา',
                style: TextStyle(
                    fontFamily: 'DBHeavent',
                    fontSize: 28,
                    color: Colors.white)),
          ]),
        ),
        body: SizedBox(
          width: MediaQuery.of(context).size.width,
          height: MediaQuery.of(context).size.height,
          child: Stack(children: [
            Container(
              color: Color.fromRGBO(77, 32, 126, 1),
              height: 60.h,
            ),
            SingleChildScrollView(
              child: Container(
                padding: EdgeInsets.only(top: 20, left: 20, right: 20),
                margin: EdgeInsets.only(left: 15, right: 15, bottom: 40),
                width: 400.h,
                decoration: BoxDecoration(
                    color: Colors.white,
                    borderRadius: BorderRadius.circular(10),
                    boxShadow: [
                      BoxShadow(
                          color: Colors.black.withOpacity(0.1),
                          spreadRadius: 3,
                          blurRadius: 6)
                    ]),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    ListTile(
                      title: Text(
                        'แสดงความเห็น',
                        style: TextStyle(
                          fontFamily: 'DBHeavent',
                          fontSize: 22,
                          color: Color.fromRGBO(77, 37, 124, 1),
                        ),
                      ),
                      leading: Radio(
                          activeColor: Colors.red,
                          value: 1,
                          groupValue: _select,
                          onChanged: (value) {
                            setState(() {
                              _select = value as int?;
                            });
                          }),
                    ),
                    ListTile(
                      title: Text(
                        'แจ้งปัญหา',
                        style: TextStyle(
                          fontFamily: 'DBHeavent',
                          fontSize: 22,
                          color: Color.fromRGBO(77, 37, 124, 1),
                        ),
                      ),
                      leading: Radio(
                          activeColor: Colors.red,
                          value: 2,
                          groupValue: _select,
                          onChanged: (value) {
                            setState(() {
                              _select = value as int?;
                            });
                          }),
                    ),
                    ListTile(
                      title: Text(
                        'เรื่องอื่นๆ',
                        style: TextStyle(
                          fontFamily: 'DBHeavent',
                          fontSize: 22,
                          color: Color.fromRGBO(77, 37, 124, 1),
                        ),
                      ),
                      leading: Radio(
                          activeColor: Colors.red,
                          value: 3,
                          groupValue: _select,
                          onChanged: (value) {
                            setState(() {
                              _select = value as int?;
                            });
                          }),
                    ),
                    Container(
                      padding: EdgeInsets.only(
                        left: 5,
                        right: 5,
                        top: 5,
                      ),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          InputData('ชื่อ', 'ชื่อ'),
                          SizedBox(
                            height: 20,
                          ),
                          InputData('นามสกุล', 'นามสกุล'),
                          SizedBox(
                            height: 20,
                          ),
                          InputData('หมายเลขโทรศัพท์ที่สามารถติดต่อกลับได้',
                              'หมายเลขโทรศัพท์'),
                          SizedBox(
                            height: 20,
                          ),
                          InputData('E-mail', 'E-mail'),
                          SizedBox(
                            height: 20,
                          ),
                          TextForm('รายละเอียด'),
                          SizedBox(
                            height: 40,
                          ),
                          Botton(context),
                          SizedBox(
                            height: 30,
                          )
                        ],
                      ),
                    ),
                  ],
                ),
              ),
            ),
          ]),
        ),
      ),
    );
  }
}

Widget InputData(String topic, String detail) {
  return Column(
    crossAxisAlignment: CrossAxisAlignment.start,
    children: [
      Text(
        topic,
        style: TextStyle(
          fontFamily: 'DBHeavent',
          fontSize: 22,
          color: Color.fromRGBO(77, 37, 124, 1),
        ),
      ),
      SizedBox(
        height: 10,
      ),
      Container(
        child: TextField(
          decoration: InputDecoration(
              border: OutlineInputBorder(
                borderRadius: BorderRadius.circular(30),
              ),
              filled: true,
              contentPadding: EdgeInsets.only(
                left: 25,
              ),
              focusedBorder: OutlineInputBorder(
                borderSide: BorderSide(color: Colors.grey),
                borderRadius: BorderRadius.circular(30),
              ),
              enabledBorder: OutlineInputBorder(
                borderSide: BorderSide(color: Colors.grey),
                borderRadius: BorderRadius.circular(30),
              ),
              hintStyle: TextStyle(
                color: Colors.grey,
                fontFamily: 'DBHeavent',
                fontSize: 25,
              ),
              hintText: detail,
              fillColor: Colors.white),
        ),
      ),
    ],
  );
}

Widget TextForm(String data) {
  return Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
    Text(
      data,
      style: TextStyle(
        fontFamily: 'DBHeavent',
        fontSize: 22,
        color: Color.fromRGBO(77, 37, 124, 1),
      ),
    ),
    SizedBox(
      height: 10,
    ),
    Container(
      child: TextFormField(
        maxLines: 10,
        decoration: InputDecoration(
            border: OutlineInputBorder(
              borderRadius: BorderRadius.circular(20),
            ),
            filled: true,
            contentPadding:
                EdgeInsets.only(left: 25, top: 25, right: 25, bottom: 5),
            focusedBorder: OutlineInputBorder(
              borderSide: BorderSide(color: Colors.grey),
              borderRadius: BorderRadius.circular(30),
            ),
            enabledBorder: OutlineInputBorder(
              borderSide: BorderSide(color: Colors.grey),
              borderRadius: BorderRadius.circular(30),
            ),
            hintStyle: TextStyle(
              color: Colors.grey,
              fontFamily: 'DBHeavent',
              fontSize: 25,
            ),
            hintText: data,
            fillColor: Colors.white),
      ),
    ),
  ]);
}

Widget Botton(BuildContext context) {
  return GestureDetector(
    onTap: () {},
    child: Container(
      height: 50,
      width: MediaQuery.of(context).size.width,
      decoration: BoxDecoration(
          gradient: LinearGradient(colors: [
            Color.fromRGBO(122, 79, 159, 1),
            Color.fromRGBO(77, 32, 126, 1)
          ], begin: Alignment.topCenter, end: Alignment.bottomCenter),
          color: Color.fromRGBO(77, 37, 124, 1),
          borderRadius: BorderRadius.circular(30)),
      child: Center(
        child: Text(
          'ส่ง',
          style: TextStyle(
            fontFamily: 'DBHeavent',
            fontSize: 25,
            color: Colors.white,
          ),
        ),
      ),
    ),
  );
}
